package gov.va.med.mhv.integration.phr.service.mvi;

/**
 * @author Rob Murtha
 */

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Set;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

/**
 * Handler for getting access to the raw inbound message. Created to work around whatever issue is
 * preventing the response from being parsed and returned normally.
 *
 * This object uses a basic RawXmlHandler interface which was designed as the interface
 * to pass back the contents of the Soap message.
 *
 * Usage: this class is registered in the web services client Binding.handlerChain
 * prior to adding at that time it should have been created or
 * injected with a RawXmlHandler object to facilitate the callback.
 *
 *     Binding binding = ((BindingProvider)vaidm).getBinding();
 *     List<Handler> handlers = binding.getHandlerChain();
 *     handlers.add(new MviMessageHandler(this));
 *     binding.setHandlerChain(handlers);

 */
public class MviMessageHandler implements SOAPHandler<SOAPMessageContext> {

    public MviMessageHandler(RawXmlHandler rawXmlHandler) {
        this.rawXmlHandler=rawXmlHandler;
    }

    private RawXmlHandler rawXmlHandler;

    public void setRawXmlHandler(RawXmlHandler handler) {
        this.rawXmlHandler = handler;
    }

    public Set<QName> getHeaders() {
        return Collections.emptySet();
    }

    public boolean handleMessage(SOAPMessageContext messageContext) {
        Boolean outboundProperty = (Boolean) messageContext.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);
        if (!outboundProperty.booleanValue()) {

            SOAPMessage soapMessage = messageContext.getMessage();
            try {

                /** this is an odd way to get the body however none of the standard SOAP objects
                  * contained the data hence the work around using a streaming interface.
                 */
                if(rawXmlHandler!=null) {
                    rawXmlHandler.setRawXml(null);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    PrintStream ps = new PrintStream(baos);
                    soapMessage.writeTo(ps);
                    rawXmlHandler.setRawXml(baos.toString());
                }

            } catch (SOAPException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public boolean handleFault(SOAPMessageContext messageContext) {
        return true;
    }

    public void close(MessageContext messageContext) {
    }
}